#!/bin/sh

# ubootupdate: utility to write a new uboot.bin to serial flash memory
# Takes exactly one parameter: the filename which contains the new uboot data

# The file in which we're gonna save the 32 bytes that contain the board's MAC
# address, name, hardware revision and serial number
SAVEFILE="/tmp/board.info"

# The device file for the serial flash
FLASH="/dev/sflash"

# The size of the flash memory in bytes
FLASHSIZE="524288"

INPUT_FILE=$1

# Check if the input file exists and actually contains data
if [ ! -s "$INPUT_FILE" ]; then
	echo "Missing or empty input file: $INPUT_FILE. Exiting." 1>&2
	exit 1
fi

# Check if the file we're going to update the flash with is not bigger than
# the flash memory itself
INPUT_FILESIZE=$(wc -c $INPUT_FILE | cut -d ' ' -f 2)
if [ $INPUT_FILESIZE -gt $FLASHSIZE ]; then
	echo "Input file $INPUT_FILE too big to fit into flash. Exiting." 1>&2
	exit 2
fi

# Save the board info
dd if=$FLASH bs=32 count=1 skip=128 of=$SAVEFILE 2>/dev/null

# Check the filesize of the save file. If it's 0 we can't read from the
# sflash!
if [ ! -s $SAVEFILE ]; then
	echo "Unable to read from serial flash device $FLASH. Exiting." 1>&2
	rm -f $SAVEFILE
	exit 3
fi

# Check if we can write anything into the serial flash. Test this by writing
# back the data we just read.
dd if=$SAVEFILE bs=32 count=1 seek=128 of=$FLASH conv=notrunc 2>/dev/null
if [ $? -ne 0 ]; then
	echo "Unable to write to serial flash device $FLASH. Exiting." 1>&2
	rm -f $SAVEFILE
	exit 4
fi

# Write the board info into the input file
dd if=$SAVEFILE bs=32 count=1 seek=128 of=$INPUT_FILE conv=notrunc 2>/dev/null

# Need to recalculate CRC?

# Write the input file onto the flash memory
dd if=$INPUT_FILE bs=65536 of=$FLASH conv=notrunc 2>/dev/null

# Remove our temp data
rm -f $SAVEFILE
