#!/bin/sh

STAT_FILE="/tmp/emptyrecordings"
COUNT=2

umount /recordings

rm -f $STAT_FILE
echolcd -e "Emptying recordings DB... \\1"
(mkfs.ext3 -I 128 -b 4096 /dev/discs/disc0/part3 -L recordings; echo "done" > $STAT_FILE) &
usleep 100000
while [ ! -f $STAT_FILE ]
do
	echolcd -e "Emptying recordings DB... \\$COUNT"
	let COUNT++
	if [ $COUNT -gt 8 ]; then
		COUNT=1
	fi
	usleep 100000
done
rm -f $STAT_FILE

mount /recordings
mkdir /recordings/trash
mkdir /recordings/tmp
mkdir /recordings/tmp/cd_queue
ln -s /proc/product.info /recordings/product.info
ln -s /var/sqlite_db/vidicode.db /recordings/vidicode.db
