<?php
  error_reporting(E_STRICT);

  session_start();

  include_once('./inc/sqlite.php');
  $sqlite=new sqlite;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
      
<html>
<head>

<title><?php echo $sqlite->getTitle(); ?></title>

<link rel="shortcut icon" href="favicon.ico"></link>

<meta http-equiv="IMAGETOOLBAR" content="no" />

<style type="text/css">
<!--
@import url(inc/sqlite.css);
-->
</style>

</head>

<body>
<div class="container">
<a href="index.php"><img src="images/logo.png" alt="PHP SQLITE ADMIN" class="logo" /></a>
<span class="version">Version <?php echo $sqlite->version;?> with SQLite Version: <?php echo sqlite_libversion();?></span>

</div>


<!-- Navagation Division -->
<div id="sidemenu">
  <div class="menuHeader"><h4 class="menuTitle"><a href="index.php">Databases</a></h4></div>
  <div class="menuheader">

<form method="get" action="<?php echo $_SERVER['PHP_SELF'];?>">
<p><select name="dbname" onchange="this.form.submit()">
<option value="">Databases ...</option>
<?php
  // loop through the array of menu items
  foreach($sqlite->topMenuArray as $item)
        {
        echo '<option ';
	// make the current dbname the selected item in the drop down
        if(isset($_GET['dbname']) && $item==$_GET['dbname']){echo 'selected="selected" ';}

	echo 'value="'.$item.'"';
        echo '>'.$sqlite->getFileName($item).'</option>'."\n";
        }
?>
  </select>
</p>
  </form>

<?php
// list all the tables in the specified database
if(isset($_GET['dbname']))
        {
	// echo a link back to the default page for the selected database
	echo '<h4 class="menuTitle"><a href="index.php?dbname='.$_GET['dbname'].'">'.$sqlite->getFileName($_GET['dbname']).'</a></h4>';

	echo '<ul>';
        // sql to select all tables from the sqlite master table
        $sql = "Select Name FROM sqlite_master WHERE type='table' ORDER BY Name";
        // run the query
        $res=$sqlite->query($sql);
        // if its good...
        if(is_resource($res))
                {
                // set a counter for the number
                $i=0;
                // loop through the array of table names
                while($row=sqlite_fetch_array($res))
                        {
                        // echo a link to each table
                        echo '<li><a href="'.$_SERVER['PHP_SELF'].'?page=browse&amp;dbname='.$_GET['dbname'].'&amp;table='.$row[0].'">'.$row['0'].'</a>';
                        // this is a little intense, but will show the number of records in each table
                        // $rec=$sqlite->query("SELECT COUNT(*) FROM ".$row[0]);
			// echo '('.sqlite_fetch_single($rec).')';
                        // while($num=sqlite_fetch_array($rec)){echo '('.$num[0].')';}
			// increment the counter.. duh
                        $i++;
			// end the list item
			echo '</li>';
                        }
  echo '</ul>';
                }
        }
  else
	{
	echo '<p>Select Database</p>';
	}
?>

 <p>
      <a href="http://validator.w3.org/check?uri=referer"><img
          src="http://www.w3.org/Icons/valid-xhtml10"
          alt="Valid XHTML 1.0!" height="31" width="88" /></a>
    </p>
  </div>
</div>




      <!-- Main Division -->
<div id="content">

<?php

  // include the nav bar
  if(isset($_GET['dbname']) && !isset($_GET['table']))
        {
        // include nav5
        include_once('./pages/nav5.php');
        }
  // check vars are set
  if(isset($_GET['dbname'], $_GET['page'], $_GET['table']))
        {
        // include nav7
        include_once('./pages/nav7.php');
        }
  // check the dbname is set and is not null value
  if(isset($_GET['dbname']) && $_GET['dbname']!='')
        {
        if(isset($_GET['GET']) && !isset($_GET['table'])){ include_once('./pages/nav5.php');}
        }
  else
        {
        echo '<p>Please Select a Database.</p>';
        }
?>

<hr />
<?php

  if(isset($_GET['page']) && in_array($_GET['page'], $sqlite->pageArray))
        {
        include_once('./pages/'.$_GET['page'].'.php');
        }
  elseif(isset($_GET['dbname']) && !isset($_GET['page']))
        {
	include('./pages/listTables.php');
        }
  else
        {
	include_once('./pages/splash.php');
        }
?>
     
</div>
       <!-- Begin Footer -->
      <div id="footer">
         
 <a href="index.php" class="non">Home</a> |
	<a href="index.php?page=ChangeLog" class="non">Change Log</a> | 
	<a href="index.php?page=TODO" class="non">TODO</a> |      
	<a href="index.php?page=credits" class="non">Credits</a> |
	<a href="index.php?page=install" class="non">Install</a> |
	<a href="http://www.phpro.org/sqlite/">PHPro.org</a>
	<h5 style="margin-bottom: 0pt;"> Copyright 2004  PHPro All Rights Reserved</h5>
</div>
   </body></html>
