<?php

  error_reporting(E_ALL);
  // if the tableNames have been selected specifically
  if(isset($_POST['tableName']))
	{
	// assign the array of tables to a var
	$tableArray = $_POST['tableName'];
	}
  else
	{
	// or put ALL the table names in the array
	$tableArray = $sqlite->getTableArray();
	}

  // add the dump prefix message
  $dump = $sqlite->dumpPrefix();
  // if we want structure of sql only
  if($_GET['dumpType']=='structure')
	{
	foreach($tableArray as $tableName)
		{
		// gets the table structure
		$dump .= $sqlite->dumpTableStructure($tableName);
		}
	}
  // if we want to dump structure and data
  elseif($_GET['dumpType']=='structureData')
	{
	foreach($tableArray as $tableName)
		{
		// gets the table structure
		$dump .= $sqlite->dumpTableStructure($tableName);
		// gets the table data
		$dump .= $sqlite->dumpTable($tableName);
		}
	}
  // if we want to dump only the data
  elseif($_GET['dumpType']=='dataOnly')
	{
	// loop through the table names
	foreach($tableArray as $tableName)
		{
		// gets the table data
		$dump .= $sqlite->dumpTable($tableName);
		}
	}
  else
	{
	// export to xml...
	$dump .= 'Coming Soon!';
	}

  // if we want the dump to download to a file we use something like this....
  if(isset($_POST['asFile']))
	{
	$len=strlen($dump);
	header("Cache-Control: public");
	header("Content-Type: application/txt");
	header("Content-Disposition: inline; filename={$sqlite->getDbName()}");
	header("Accept-Ranges: bytes");
	header("Content-Length: {$len}");
	echo $dump;
	}
  else
	{
	print '<p class="dump">'.nl2br($dump).'</p>';
	}
?>
